/************************************************************************\
	Copyright (C) 1996 Les R. Titze
\************************************************************************/

#include "objects.h"
#include "NewtonScript.h"

enum {
	e_unknown = 0,
	e_package = 1,
	e_frame   = 2,
	e_text    = 3,
	e_noMoreEnums
};

struct erFrameHdr {
	long		mark1;	// 0xA54E5746 == "NWF"
	long		mark2;	// 0x0D0A1A0A == <CR> <LF> <ctl-Z> <LF>
	long		dataSize;
	short		crc16;
	short		zeroVal;
};


long _guessBinType ( void * binP );

extern "C" Ref GuessBinType ( RefArg rcvr, RefArg binObj )
{
	if ( !IsBinary(binObj) )
		ThrowBadTypeWithFrameData ( -48408, binObj );	// expected a binary object

	long resultEnum;

	WITH_LOCKED_BINARY ( binObj, binP )

		resultEnum = _guessBinType ( binP );

	END_WITH_LOCKED_BINARY ( binObj )

	return MakeInt ( resultEnum );
}


long _guessBinType ( void * binDataP )
{
	long	* lP = (long *)binDataP;
	short	* sP = (short *)binDataP;
	char	* cP = (char *)binDataP;
	struct	erFrameHdr	* hP = (struct erFrameHdr *)binDataP;

	if ( (hP->mark1 == 0xA54E5746)
	&&   (hP->mark2 == 0x0D0A1A0A)
	&&   (hP->zeroVal == 0) )
	{
		return e_frame;
	}
	short	notPkg = 0;
	char pkgStr[] = "package";
	for ( short i = 0; i < sizeof(pkgStr)-1; i++ )
	{
		if ( ! ( pkgStr[i] == cP[i] ) )
		{
			notPkg = 1;
		}
	}
	if ( ! notPkg )
	{	// check a <ZERO-SHORT> at 10 and two <MUST-EQUAL> values
		if ( sP[10] == 0
		&& ( sP[11] && (sP[11] == sP[12]) )
		&& ( lP[14] && (lP[14] == lP[15]) ) )
			return e_package;
	}


	return e_unknown;
}
